# these functions assume that timeline_1_2 and ready_1_2 dataframes exist in environment

plot_run <- function(runiid){
  desc <- ready_1_2[ready_1_2$No == runiid,]
  timelines <- timeline_1_2[timeline_1_2$No == runiid,]
  timelines$runoffrate <- timelines$runoffrate/desc$plotwidth
  
  allruns <- read.csv(paste0("run",runiid,"_allruns.csv"), row.names = "X")
  ts <- which(grepl("t_",names(allruns)))
  time_delayed <- as.numeric(gsub(pattern = "t_","",names(allruns[,ts])))+60
  
  ks_exper_end <- desc$kscampbell * e3dpar$skin_end[e3dpar$No == runiid] * 9.81e-3
  ks_exper_run <- desc$kscampbell * e3dpar$skin_run[e3dpar$No == runiid] * 9.81e-3  
  
  
  par(mfrow=c(1,1))

    plot(time_delayed,unlist(allruns[1,ts])/desc$plotlength, type = "l", ylim = range(timelines$rainfall), ylab="Runoff / Precipitation rate [m/s]", xlab="Time [s]")
    #for (i in 1:200){points(time_delayed,unlist(allruns[i,ts])/desc$plotlength, type = "l", col="grey")}
    #points(time_delayed,unlist(allruns[1,ts])/desc$plotlength, type = "l")
    points(timelines$time,timelines$runoffrate/desc$plotlength, col = "red")
    points(timelines$time,c(timelines$rainfall[2],timelines$rainfall[2:length(timelines$rainfall)]), type = "l", col = "blue")
  
    points(time_delayed,unlist(allruns[1,ts])/desc$plotlength, type = "l")
    
  try({
      skinend <- which(abs(allruns$pf - desc$pf_exper)<0.00000000001 & abs(allruns$ks - ks_exper_end)<0.00000000001)[1]
      skinrun <- which(abs(allruns$pf - desc$pf_exper)<0.00000000001 & abs(allruns$ks - ks_exper_run)<0.00000000001)[1]
#      equalks <- which(abs(allruns$ks - desc$kscampbell* 9.81e-3)<0.00000001)[1]
      points(time_delayed,unlist(allruns[skinend,ts])/desc$plotlength, pch = 13, cex = 0.4)
      points(time_delayed,unlist(allruns[skinrun,ts])/desc$plotlength, pch = 12, cex = 0.4)
#      lines(time_delayed,unlist(allruns[equalks,ts])/desc$plotlength, lty = 3, cex = 0.4)
  }
  )

#    legend("topleft", inset=0.05, legend=c("rainfall", "measured", "pf/ks fit", "ks fit - end infil", "ks fit - cum runoff", "pf fit"),
#           col=c("blue", "red", "black", "black", "black", "black"), lty=c(1,NA,1,NA,NA,2), pch=c(NA,1,NA,13,12,NA), cex=0.8)
    legend("topleft", inset=0.05, legend=c("rainfall", "measured", "pf/ks fit", "ks fit - end infil", "ks fit - cum runoff"),
           col=c("blue", "red", "black", "black", "black"), lty=c(1,NA,1,NA,NA), pch=c(NA,1,NA,13,12), cex=0.8)
 
}

