#running random E3D simulation to add E3D into %PATH%
toolbox.e3d::determine.skin.runoff.E3D(Cl = 30, Si = 40, Sa = 30, Corg = 1.3, Bulk = 1300, Moist = 22, CumRunoff = 100, intensity = 0.5, plotwidth = 1, plotlength = 10, slope = 10, endmin = 30, ponding = TRUE)


#change setting in e3d.ini in user folder to enable pour-point observation
user_setting <- ini::read.ini("c:/Users/beitlerova.hana/AppData/Roaming/GeoGnostics/Erosion3D-320/e3d.ini")
user_setting$Simulation$save_wsdpp <- 2
ini::write.ini(user_setting, "c:/Users/beitlerova.hana/AppData/Roaming/GeoGnostics/Erosion3D-320/e3d.ini")


simlines <- 5000
#path = tempdir()
path = 'P:\\14919\\149_Ksat\\E3D'
delay_runoff = FALSE

for (runiid in ready_1_2$No[!is.na(ready_1_2$fSa) & !is.na(ready_1_2$rough) & !is.na(ready_1_2$cover)])
{

print(runiid)
  if(file.exists(paste0("run",runiid,"_allruns.csv"))){next()}

# skip run M1.3, as only 3 time stamps meet simulated full minute time stamps
if(runiid =="M1.3"){next()}
  
timelines <- timeline_1_2[timeline_1_2$No == runiid,]
desc <- ready_1_2[ready_1_2$No == runiid,]

timelines$runoffrate <- timelines$runoffrate/desc$plotwidth

if(sum(desc$CLAY,desc$fSi,desc$mSi,desc$cSi,desc$fSa,desc$mSa, desc$cSa)!=100 | any(!is.integer(desc$CLAY),!is.integer(desc$fSi),!is.integer(desc$mSi),!is.integer(desc$cSi),!is.integer(desc$fSa),!is.integer(desc$mSa),!is.integer(desc$cSa)))
{
  desc$CLAY <- round(desc$CLAY)
  desc$fSi <- round(desc$fSi)
  desc$mSi <- round(desc$mSi)
  desc$cSi <- round(desc$cSi)
  
  desc$fSa <- round(desc$fSa)
  desc$mSa <- round(desc$mSa)
  desc$cSa <- 100 - sum(desc$CLAY,desc$fSi,desc$mSi,desc$cSi,desc$fSa,desc$mSa)
}

slope=round(desc$slope)

toolbox.e3d::create_folders.E3D(path, overwrite = TRUE)

#adjust that write.rainfile.E3D uses rainfall intensities for following timesteps, while given intensity is valid for preceeding timestep
toolbox.e3d::write.rainfile.E3D(time = c(0,timelines$time[-1]), intens = c(timelines$rainfall[-1]*1000*60,0), path = path, filename = "model/rain_e3d.csv")
  
toolbox.e3d::write.relief.E3D(POLY_ID = 1:simlines,length = desc$plotlength, slope = slope,path = path, filename = "model/dem.asc")
system2("e3d", paste0("/r \"", normalizePath(file.path(path, "model/run.par")), "\""), wait = TRUE)
  
toolbox.e3d::write.landuse.E3D(POLY_ID = 1:simlines,length = desc$plotlength, path = file.path(path,"model/"), filename = "landuse.asc")
  
soils <- read.csv(file.path(path, "model/soil/soil_params.csv"))[1,]
soils$BLKDENSITY <- desc$bulk
soils$CORG <- desc$corg
soils$COVER <- desc$cover
soils$FT <- 0
soils$MT <- desc$CLAY
soils$GT <- 0
soils$FU <- desc$fSi
soils$MU <- desc$mSi
soils$GU <- desc$cSi
soils$FS <- desc$fSa
soils$MS <- desc$mSa
soils$GS <- desc$cSa

#observation of runoff volume can be done with definition of POUR-points
POUR <- raster::raster(
  resolution = 1,
  xmn = 0,
  xmx = desc$plotlength,
  ymn = 0,
  ymx = simlines,
  crs = "+proj=robin +datum=WGS84", 
  vals = -9999)
POUR[,1] <- 1:simlines
  
raster::writeRaster(
  POUR,
  filename = file.path(path, "model/relief/POUR.asc"), 
  format = "ascii",
  overwrite = TRUE, datatype = "INT2S"
)
  
if(delay_runoff)
{
  #delay runoff (use kinematic wave option)
  toolbox.e3d::change_settings.E3D(path, filename = "model/run.par",
                                   module = c("Runoff_model"),
                                   setting = c("DelayRunoff"),
                                   value = c("1")
  )
}
  

### complete model setup
soils[2:simlines,] <- soils[1,]
soils$POLY_ID <- 1:simlines

ks_exper_end <- desc$kscampbell * e3dpar$skin_end[e3dpar$No == runiid] * 9.81e-3
ks_exper_run <- desc$kscampbell * e3dpar$skin_run[e3dpar$No == runiid] * 9.81e-3

n = 0

range_pf <- range_pf_init <- c(0,7)
if(is.finite(ks_exper_end) & !is.na(ks_exper_end)){
  range_pks <- range_pks_init <- c((log10(ks_exper_end)-4),(log10(ks_exper_end)+4))
}else{range_pks <- range_pks_init <- c(-9,-3)}


### vary parameters
while(n<5001)
{
pf = runif(simlines,range_pf[1],range_pf[2])
ks = 10^(runif(simlines,range_pks[1],range_pks[2]))
#mannings_n = 10^runif(simlines,-4,-1)

if(n==0 & is.finite(ks_exper_end) & !is.na(ks_exper_run))
{
  pf[1:2] <- desc$pf_exper
  ks[1:2] <- c(ks_exper_end, ks_exper_run)
}


print(range(ks))
print(range_pf)
#set initmoist, to meet set matrixpotential

soils$INITMOIST <- toolbox.e3d::pF_to_moist.E3D(THETA_S = desc$theta_s, THETA_R = desc$theta_r, pF = pf, ALPHA = desc$alpha, NORDPOL = desc$nord)
#  delta_theta <-  theta_s - soils$INITMOIST/100 
  
#set skin, to meet set ks (Campbell-Calculation)
soils$SKINFACTOR <- ks/(desc$kscampbell*9.81e-3)
#soils$ROUGHNESS <- mannings_n

utils::write.csv(soils, file.path(path, "model/soil_params.csv"), row.names = FALSE, quote = FALSE)

system2("e3d", paste0("/c \"", normalizePath(file.path(path, "model/run.par")), "\""), wait = TRUE)
result_delay <- read.csv(file.path(path, "model/result/pp_data.csv"))

resultdf <- cbind.data.frame(ks, pf)

Res <- as.POSIXlt(paste(Sys.Date(), result_delay$Time[result_delay$ID ==1]))
time_delayed = Res$hour*60*60 + Res$min*60

resultdf[,c("RMSE",paste0("t_",time_delayed))] <- NA

for(i in 1:simlines)
{
  curve <- c(0,diff(result_delay$Runoff[result_delay$ID ==i]))/60 
  resultdf[i,4:ncol(resultdf)] <- curve
  combined <- merge(timelines[,c("time","runoffrate")],cbind(time = time_delayed,curve))
  resultdf$RMSE[i] <- sqrt(mean((combined$curve - combined$runoffrate)^2))
}

if(exists("allruns")){allruns <- rbind.data.frame(allruns, resultdf)}else{allruns <- resultdf}
if(!is.na(ks_exper_end) & n==0)
{
 RMSE_skin_run <- allruns$RMSE[2]
}
n = nrow(allruns)
allruns <- allruns[order(allruns$RMSE),]
# if RMSE equals zero, perfect fit is found (usually only possible for zero runoff runs)
if(any(allruns$RMSE==0)){n=Inf}


## define new search limits - select all runs with better RMSE than best gues with skinfactor to runoff
good_RMSE <- which(allruns$RMSE < RMSE_skin_run)

range_pks <- log10(range(allruns$ks[good_RMSE]))
range_pf <- (range(allruns$pf[good_RMSE]))
}


write.csv(allruns, paste0("run",runiid,"_allruns.csv"))
rm(combined,Res,result_delay,resultdf,b,curve,i,ks, pf,n)
rm(allruns,desc,soils,timelines,slope,time_delayed)
}

#reset setting in e3d.ini in user folder to "standard"
user_setting <- ini::read.ini("c:/Users/beitlerova.hana/AppData/Roaming/GeoGnostics/Erosion3D-320/e3d.ini")
user_setting$Simulation$save_wsdpp <- 0
ini::write.ini(user_setting, "c:/Users/beitlerova.hana/AppData/Roaming/GeoGnostics/Erosion3D-320/e3d.ini")

