//watchdog tool
#include <avr/wdt.h>

//RTC libraries
#include <DS3231.h>
#include <Wire.h>

#include "LowPower.h"

// pin assignments 
int optocopler = 10; //switch for camera control

//variables for camera control
int val = 0;
int i = 0;
int img_nbr = 1;

//relevant for rtc
//set time?
bool set_time = false;

//set trigger time
String camera_awake_hour = "10"; //set at what hour during day take image
String camera_awake_minute = "00";  //set at what minutes during hour take image
//String camera_awake_minute_2 = "30";
DS3231 rtc(SDA, SCL);
Time t;
String minute_rtc, minute_rtc_1, minute_rtc_2; 
String hour_rtc, hour_rtc_1, hour_rtc_2;
int minute_rtc_int;


//to check that RTC still working
String year_rtc, year_rtc_1, year_rtc_2;
int cycle_count = 0;
int cycles = 7200; //300 (1 hour)

//relevant for power consumption
int power_down_cycle = 20;  //*4sec

void setup() {
  cycle_count = cycle_count + 1;

  //set up built in led to keep powerbank awake
  pinMode(LED_BUILTIN, OUTPUT);

  //set up camera control pin
  pinMode(optocopler, OUTPUT); 
  digitalWrite(optocopler, LOW);

  Serial.begin(9600);

  //setup watchdog
  wdt_enable(WDTO_8S);

  //set up rtc to print
  delay(200);
  Serial.println("DS1307RTC Read Test");
  Serial.println("-------------------");

  // Initialize the rtc object
  rtc.begin();

  if (set_time == true){
    rtc.setDOW(THURSDAY);     // Set Day-of-Week to SUNDAY
    rtc.setTime(18, 23, 10);     // Set the time to 12:00:00 (24hr format)
    rtc.setDate(21, 04, 2021);   // Set the date to January 1st, 2014
  }
}

void loop() {
  wdt_reset();

  // Send Day-of-Week
  Serial.print(rtc.getDOWStr());
  Serial.print(" ");  
  // Print date
  Serial.print(rtc.getDateStr());
  Serial.print(" -- ");  
  // Print time
  Serial.println(rtc.getTimeStr());

  Serial.print(" cycle count "); Serial.println(cycle_count);

  //control LEDs
  digitalWrite(LED_BUILTIN, HIGH);  // turn the LED on (HIGH is the voltage level)
  delay(100);                       // wait for 10 milliseconds
  digitalWrite(LED_BUILTIN, LOW); // turn the LED off by making the voltage LOW

  //setup task at specific time (read time from RTC)
  String time_rtc = rtc.getTimeStr();
  minute_rtc_1 = time_rtc.charAt(3); minute_rtc_2 = time_rtc.charAt(4);  
  minute_rtc = minute_rtc_1 + minute_rtc_2;
  Serial.print(" minute "); Serial.println(minute_rtc); 
  hour_rtc_1 = time_rtc.charAt(0); hour_rtc_2 = time_rtc.charAt(1); 
  hour_rtc = hour_rtc_1 + hour_rtc_2;
  Serial.print(" hour "); Serial.println(hour_rtc);
  Serial.println(" time read");
  
  //check that RTC still working
  String date_rtc = rtc.getDateStr();
  year_rtc_1 = date_rtc.charAt(8); year_rtc_2 = date_rtc.charAt(9);
  year_rtc = year_rtc_1 + year_rtc_2;
  Serial.print(" year "); Serial.println(year_rtc);
  
  //if rtc is working do next step
  if (year_rtc != "00")
    {
    //signalise that time not working
    signal_timeWork();    
    cycle_count = 0;  

    //if correct time start trigger process
    if (hour_rtc == camera_awake_hour)  //((minute_rtc_2.toInt() % 2) == 0)  (hour_rtc == camera_awake_hour)
      {   
        if (minute_rtc == camera_awake_minute)
        { 
        Serial.println("trigger camera RTC");   
        trigger_camera();        
        
        //wait long enough, so not caught in capture cycle again
        for (int k=0; k < power_down_cycle; k++)
          {
          wdt_reset();
          LowPower.powerDown(SLEEP_4S, ADC_OFF, BOD_OFF);
          }
        }
      }
    }
  
  //if rtc not working check if count cycles (as backup reached time interval)
  if(cycle_count > cycles)
    {
    cycle_count = 0;
    Serial.println("trigger camera cycles");
    trigger_camera();
    }
  //if rtc not working and time interval not reached, count cycle
  else
    {
    cycle_count = cycle_count + 1;
    }
  
sleep_arduino();
}

void trigger_camera(){
 for (int j=0; j<img_nbr; j++)
  {
    digitalWrite(optocopler, HIGH);
    delay(300);
    digitalWrite(optocopler, LOW);
    delay(500);
    wdt_reset();
    return;
  }
}

void sleep_arduino(){
  delay(20);
  wdt_reset();
  LowPower.powerDown(SLEEP_4S, ADC_OFF, BOD_OFF);
  delay(10);
  wdt_reset();
  LowPower.powerDown(SLEEP_4S, ADC_OFF, BOD_OFF);
  delay(10);
  wdt_reset();
  LowPower.powerDown(SLEEP_4S, ADC_OFF, BOD_OFF);
  delay(10);
  wdt_reset();
}

void signal_timeWork(){
  wdt_reset();
  digitalWrite(LED_BUILTIN, HIGH);   // turn the LED on twice if too dark
  delay(20);                      
  digitalWrite(LED_BUILTIN, LOW);
  delay(20);  
  digitalWrite(LED_BUILTIN, HIGH);   
  delay(20);                      
  digitalWrite(LED_BUILTIN, LOW);
  delay(20);  
  digitalWrite(LED_BUILTIN, HIGH);   
  delay(20);                      
  digitalWrite(LED_BUILTIN, LOW);     
  wdt_reset();
}
