#use Python3
import sys, os, csv
import time, datetime
import camera_functions as cam_func
from picamera import PiCamera


#delay to mount usb
time.sleep(1)

mount_id = 'sd' #'CFB1-4F7D'
directory_save_ext = '/media/usb/'

directory_out = '/home/pi/camera_pi/images/'
if not os.path.exists(directory_out):
    os.system('sudo mkdir ' + directory_out)
directory_log = '/home/pi/camera_pi/'
if not os.path.exists(directory_log):
    os.system('sudo mkdir ' + directory_log)

dailyStartString = '09-0'

time_lapse_interval = int(20) #in seconds
timeWaitThermal = int(5)

img_nbr = 1     #per interval
vid_len = int(10)

thermalCaptureAlso = True
thermalExe = '/home/pi/thermalcamera/te_q1_vers1'

#prepare logfile
if not os.path.isfile(os.path.join(directory_log, 'log_camera.txt')):
    write_log = open(os.path.join(directory_log, 'log_camera.txt'), 'wt')
    writer = csv.writer(write_log)
    writer.writerow(['folder saved to', 'time', 'time lack still video'])
else:
    write_log = open(os.path.join(directory_log, 'log_camera.txt'), 'a')
    writer = csv.writer(write_log)

write_log.flush()


#prepare backup place images
device_name = cam_func.get_specific_mount_location(mount_id)
if device_name[0] == 'noDevice':
    try:
        device = cam_func.get_unmounted_devices()
        device = device + '1'
        if not os.path.exists(directory_save_ext):
            os.system('sudo mkdir ' + directory_save_ext)
        os.system('sudo mount ' + device + ' ' + directory_save_ext)
        print('newly mounted device: ' + device)
        copyToExt = 1
    except:
        print('no usb detected')
        copyToExt = 0
else:
    os.system('sudo umount ' + device_name[0] + ' ' + device_name[1] + '/')
    if not os.path.exists(directory_save_ext):
        os.system('sudo mkdir ' + directory_save_ext)
    os.system('sudo mount ' + device_name[0] + ' ' + directory_save_ext)
    print('re-mounted device: ' + device_name[0])
    copyToExt = 1

#start camera
try:
    camera = PiCamera()
    camera.ISO = 0
    
    #wait to allow good AWB
    time.sleep(2)    
except:
    print('failed starting camera')

#capture image and video
i = 0
date_fold_start = str('___')
while True:
    #get time for img and vid name
    datetime_fold= datetime.datetime.now()
    datetime_name = str(datetime_fold)[0:10] + '_' + str(datetime_fold)[11:13] + '-' + str(datetime_fold)[14:16] + '-' + str(datetime_fold)[17:19]
    directory_daily_out = directory_out + str(datetime_fold)[0:10] + '/'
    if not os.path.exists(directory_daily_out):
        os.system('mkdir ' + directory_daily_out)

    try:
        camera.resolution=(2592,1944)

        #check if bright enough
        bright_enough = cam_func.lux_sense(4, 17)
        if bright_enough == 1:
            continue

        #capture image
        for img in range(img_nbr):
            camera.capture(directory_daily_out + datetime_name + '_' + str(img) + '.jpg')
            time.sleep(0.5)
        print('images captured of iteration ' + str(i))
            
        #capture video
        camera.resolution = (1640,922)
        camera.framerate = 40
        camera.start_recording(directory_daily_out + datetime_name + '.h264')
        time.sleep(vid_len)
        camera.stop_recording()
        #camera.stop_preview()
        #camera.resolution=(3280,2464)
        print('video captured of iteration ' + str(i))
    
    except:
        print('failed capturing images with Pi camera')

    #write logfile
    writer.writerow([str(datetime_name), str(time.time())])
    write_log.flush()

    #capture thermal images
    if thermalCaptureAlso:
        try:
            directory_minutely_outThermal = directory_daily_out + 'thermal/'
            if not os.path.exists(directory_minutely_outThermal):
                os.system('mkdir ' + directory_minutely_outThermal) 
            directory_minutely_outThermal = directory_minutely_outThermal + str(datetime_fold)[0:10] + '_' + str(datetime_fold)[11:13] + '-' + str(datetime_fold)[14:16] + '/'
            if not os.path.exists(directory_minutely_outThermal):
                os.system('mkdir ' + directory_minutely_outThermal) 
            os.system('sudo ' + thermalExe + ' ' + directory_minutely_outThermal)
            time.sleep(timeWaitThermal)
        except:
            print('failing to run thermal caemera')

    try:
        #setup folder
        if copyToExt == 1:
            date_fold = str(datetime_fold)[0:10]
            directory_save_imgs = directory_save_ext + 'images/' + date_fold + '/'
            print('output folder: ' + directory_save_imgs)
            if not os.path.exists(directory_save_imgs):
                os.system('mkdir ' + directory_save_imgs)
            #copy files
            os.system('sudo cp -r -f ' + directory_out + '* ' + directory_save_imgs)
            os.system('sudo cp -r -f ' + directory_log + 'log_camera.txt ' + directory_save_ext + 'images/')
            os.system('sudo rm -r -f ' + directory_out + '*')

        else:
            print('not copied to usb')

    except:
        print('could not copy files')            

    #perform measurement only once if Pi started due to daily image capture
    if str(datetime_fold)[11:13] + '-' + str(datetime_fold)[14:15] == dailyStartString:
        print(str(datetime_fold)[11:13] + '-' + str(datetime_fold)[14:15])
        print('program finished after capturing only once')
        break
    
    #time lapse interval
    time.sleep(time_lapse_interval)

    i = i + 1
