from __future__ import print_function
import serial, io
import sys, traceback, os
from picamera import PiCamera
import time
import datetime
import RPi.GPIO as GPIO
import os
from glob import glob
from subprocess import check_output, CalledProcessError


#### ----- ####
'''usb regards'''
def usb_info(id_usb):
    import re
    import subprocess
    device_re = re.compile("Bus\s+(?P<bus>\d+)\s+Device\s+(?P<device>\d+).+ID\s(?P<id>\w+:\w+)\s(?P<tag>.+)$", re.I)
    df = subprocess.check_output("lsusb")
    #devices = []
    for i in df.split('\n'):
        if i:
            info = device_re.match(i)
            if info:
                dinfo = info.groupdict()
                dinfo['device'] = '/dev/bus/usb/%s/%s' % (dinfo.pop('bus'), dinfo.pop('device'))
                if id_usb == dinfo['id']:
                    return(dinfo['device'])
    return('noDevice')


#### get mount location ####
def get_usb_devices():
    sdb_devices = map(os.path.realpath, glob('/sys/block/sd*'))
    usb_devices = (dev for dev in sdb_devices
        if 'usb' in dev.split('/')[5])
    return dict((os.path.basename(dev), dev) for dev in usb_devices)

def get_mount_points(devices=None):
    devices = devices or get_usb_devices() # if devices are None: get_usb_devices
    output = check_output(['mount']).splitlines()
    is_usb = lambda path: any(dev in path.decode('utf-8') for dev in devices)
    usb_info = (line for line in output if is_usb(line.split()[0]))
    return [(info.split()[0], info.split()[2]) for info in usb_info]

def get_specific_mount_location(mount_id):
    mount_points = get_mount_points()
    #print(mount_points)
    for i in mount_points:
        if i:
            if mount_id in i[0].decode('utf-8'):
                return([i[0].decode('utf-8'), i[1].decode('utf-8')])
    return(['noDevice', 0])

def get_unmounted_devices():
    partitionsFile = open("/proc/partitions")
    lines = partitionsFile.readlines()[2:]#Skips the header lines
    for line in lines:
        words = [x.strip() for x in line.split()]
        minorNumber = int(words[1])
        deviceName = words[3]
        if minorNumber % 16 == 0:
            path = "/sys/class/block/" + deviceName
            if os.path.islink(path):
                if os.path.realpath(path).find("/usb") > 0:
                    #print("/dev/%s" % deviceName)
                    return("/dev/%s" % deviceName)

#### ----- ####
            

#### ----- ####
'''gps regards'''
def gps_time(wait_time):
    addr  = '/dev/ttyAMA0'  # serial port to read data from
    baud  = 9600            # baud rate for serial port
    fname = 'gps-log.dat'   # log file to save data in
    fmode = 'a'             # log file mode = append
    loops_gps = 3           # skip nbr of GPS readings before using

    start_time = time.time()
    gps_time = 0
    with serial.Serial(addr,9600) as pt:
        spb = io.TextIOWrapper(io.BufferedRWPair(pt,pt,1),
                               encoding='ascii', errors='ignore', newline='\r',line_buffering=True)
        spb.readline()  # throw away first line; likely to start mid-sentence (incomplete)

        time_gps_count = 0
        while int((time.time()-start_time)) < wait_time:
            x = spb.readline()  # read one line of text from serial port
            #print (x,end='')    # echo line of text on-screen
        
            if'$GPRMC' in x:      #$GPRMC,,V,,,,,,,,,,N*53
                x_split = x.strip().split(',')
                time_gps = x_split[1]

                if not time_gps == '':
                    time_gps_count = time_gps_count + 1
                    if time_gps_count == loops_gps:
                        break

    return(gps_time)
#### ----- ####


#### ----- ####
'''light regards'''
def lux_sense(i_range, gpio_pin):
    GPIO.setmode(GPIO.BCM)
    GPIO.setup(gpio_pin,GPIO.IN)

    for i in range(i_range):
        yes_no = GPIO.input(gpio_pin)
        time.sleep(0.25)

    return(yes_no)

def use_lighting(gpio_pin):
    bright_enough = lux_sense(4, gpio_pin)

    if bright_enough == 1:
        print('Light on...')
        LEDs = [1,2,3,4,5,6,7,8]
        lights = True   
        for led in LEDs:  #increase brightness of each lamp
            brpi.dim_led(led, 50)
            brpi.set_led_state(led, not brpi.get_led_state(led))
    else:
        print('No light needed. Bright enough...')
#### ----- ####


#### ----- ####
'''camera regards'''
def scene_preview(duration):
    camera = PiCamera()
    camera.start_preview(fullscreen=False, window=(0,0,500,500))
    print('Preview started for ' + str(duration) + ' seconds')
    camera.resolution=(2592, 1944)
    time.sleep(duration)
    camera.stop_preview()
    
    
def master_prepare(directory_out, lux_sensor=False):
    if lux_sensor:
        import brightpi as brpi
    
    lights = False  #LEDs turned off
    
    camera = PiCamera()
    camera.resolution=(2592, 1944)
    camera.start_preview(fullscreen=False, window=(0,0,250,250))

    datetime_fold= datetime.datetime.now()
    date_fold = str(datetime_fold)[0:10]
    datetime_name = str(datetime_fold)[0:10] + '_' + str(datetime_fold)[11:13] + '-' + str(datetime_fold)[14:16] + '-' + str(datetime_fold)[17:19]
    datetime_hour = int(str(datetime_fold)[11:13])
    
    '''create folder to store data'''
    directory = directory_out + date_fold + '/'
    if not os.path.exists(directory):
        os.makedirs(directory)
    
    '''consider if enough daylight'''
    if lux_sensor:
        bright_enough = lux_sense(4, 23)

        if bright_enough == 1:
##        if datetime_hour >= 17 or datetime_hour <= 6:
            print('Light on...')
            LEDs = [1,2,3,4,5,6,7,8]
            lights = True   
            for led in LEDs:  #increase brightness of each lamp
                brpi.dim_led(led, 50)
                brpi.set_led_state(led, not brpi.get_led_state(led))
        else:
            print('No light needed. Bright enough...')

    '''prepare take images in a sequence'''
    camera.ISO = 0

    #wait some time to allow good AWB
    time.sleep(5)

    return(camera, datetime_name, directory, lights)

def master_capture(camera, directory, datetime_name, lights=False, video_len=5):   #img_range=3
    '''capture an image'''
##    camera.capture(directory + datetime_name + '__0.jpg')    
##
##    for i in range(img_range):
##        camera.capture(directory + datetime_name + '_' + str(i) + '.jpg')
##        time.sleep(0.5)

    '''capture a video'''
    camera.resolution = (1920,1080)
    camera.framerate = 30   #30 highest possible but than lower resolution

    time_lack_vid = time.time()
    
    camera.start_recording(directory + datetime_name + '.h264')
    time.sleep(video_len)
    camera.stop_recording()
    
    camera.stop_preview()

    '''turn off lights'''
    if lights:
        import brightpi as brpi
        brpi.switch_leds_off()


    return(time_lack_vid)
    

def slave_prepare(directory_out):
    camera = PiCamera()
    camera.resolution=(2592, 1944)
    camera.start_preview(fullscreen=False, window=(0,0,250,250))

    datetime_fold= datetime.datetime.now()
    date_fold = str(datetime_fold)[0:10]
    datetime_name = str(datetime_fold)[0:10] + '_' + str(datetime_fold)[11:13] + '-' + str(datetime_fold)[14:16] + '-' + str(datetime_fold)[17:19]
    datetime_hour = int(str(datetime_fold)[11:13])
    
    '''create folder to store data'''
    directory = directory_out + date_fold + '/'
    if not os.path.exists(directory):
        os.makedirs(directory)
    
    '''take images in a sequence'''
    camera.ISO = 0

    #wait to allow good AWB
    time.sleep(5)

    return(camera, datetime_name, directory)

def slave_capture(camera, directory, datetime_name, trigger_delays=None, video_len=5):    #img_range=3
    '''capture an image'''
##    camera.capture(directory + datetime_name + '__0.jpg')
##
##    if not trigger_delays == None:
##        if not len(trigger_delays) == img_range:
##            print('error: nbr imgs not equal nbr delays')
##            sys.exit(0)
##    for i in range(img_range):
##        camera.capture(directory + datetime_name + '_' + str(i) + '.jpg')
##        if not trigger_delays == None:
##            time.sleep(0.5 + trigger_delays[i])
##        else:
##            time.sleep(0.5)

    '''capture a video'''
    camera.resolution = (1920,1080)
    camera.framerate = 30   #30 highest possible but than lower resolution

    time_lack_vid = time.time()
    
    camera.start_recording(directory + datetime_name + '.h264')
    time.sleep(video_len)
    camera.stop_recording()
    
    camera.stop_preview()

    return(time_lack_vid)
#### ----- ####



##def camera_master(directory_out, trigger_time=time.time(),
##                  lux_sensor=False, img_range=4):    
##    if lux_sensor:
##        import brightpi as brpi
##    
##    if trigger_time > time.time():
##        trigger_time_vid = trigger_time + 10
##    else:
##        trigger_time_vid = 0
##
##    lights = False  #LEDs turned off
##    
##    camera = PiCamera()
##    camera.resolution=(2592, 1944)
##    camera.start_preview(fullscreen=False, window=(0,0,500,500))
##    #camera.quality=100
##
##    datetime_fold= datetime.datetime.now()
##    date_fold = str(datetime_fold)[0:10]
##    datetime_name = str(datetime_fold)[0:10] + '_' + str(datetime_fold)[11:13] + '-' + str(datetime_fold)[14:16] + '-' + str(datetime_fold)[17:19]
##    datetime_hour = int(str(datetime_fold)[11:13])
##    
##    '''create folder to store data'''
##    #directory_out = '/media/pi/INTENSO/images/'
##    directory = directory_out + date_fold + '/'
##    if not os.path.exists(directory):
##        os.makedirs(directory)
##
##    
##    '''consider if enough daylight'''
##    if lux_sensor:
##        if datetime_hour > 7 or datetime_hour < 10:
##            LEDs = [1,2,3,4,5,6,7,8]
##            lights = True   
##            for led in LEDs:  #increase brightness of each lamp
##                brpi.dim_led(led, 50)
##                brpi.set_led_state(led, not brpi.get_led_state(led))
##            
##
##    '''take images in a sequence'''
##    camera.ISO = 0
##
##    print('time: ' + str(time.time()) + '; trigger time: ' + str(trigger_time))
##    if trigger_time > time.time():
##        while time.time() < trigger_time:
##            continue
##
##    #wait some time to allow good AWB
##    time.sleep(5)
##
##    for i in range(img_range):
##        camera.capture(directory + datetime_name + '_' + str(i) + '.jpg')
##        time.sleep(0.5)
##
##
##    '''capture a video'''
##    camera.resolution = (1920,1080)
##    camera.framerate = 30   #30 highest possible but than lower resolution
##
##    if trigger_time_vid > time.time():
##        while time.time() < trigger_time_vid:
##            continue
##    
##    camera.start_recording(directory + datetime_name + '.h264')
##    time.sleep(5)
##    camera.stop_recording()
##    
##    camera.stop_preview()
##
##
##    '''turn off lights'''
##    if lux_sensor:
##        if lights:
##           brpi.switch_leds_off()
##
##   
##    '''shut down pi'''
##    #os.system('shutdown now -h')
##
##
##def camera_slave(directory_out, trigger_time=time.time(), trigger_delays=None, img_range=3):
##    if trigger_time > time.time():
##        trigger_time_vid = trigger_time + 10
##    else:
##        trigger_time_vid = 0
##
##    camera = PiCamera()
##    camera.resolution=(2592, 1944)
##    camera.start_preview(fullscreen=False, window=(0,0,500,500))
##    #camera.quality=100
##
##    datetime_fold= datetime.datetime.now()
##    date_fold = str(datetime_fold)[0:10]
##    datetime_name = str(datetime_fold)[0:10] + '_' + str(datetime_fold)[11:13] + '-' + str(datetime_fold)[14:16] + '-' + str(datetime_fold)[17:19]
##    datetime_hour = int(str(datetime_fold)[11:13])
##    
##    '''create folder to store data'''
##    #directory_out = '/media/pi/INTENSO/images/'
##    directory = directory_out + date_fold + '/'
##    if not os.path.exists(directory):
##        os.makedirs(directory)
##
##    
##    '''take images in a sequence'''
##    camera.ISO = 0
##
##    print('time: ' + str(time.time()) + '; trigger time: ' + str(trigger_time))
##    if trigger_time > time.time():
##        while time.time() < trigger_time:
##            continue
##
##    #wait to allow good AWB
##    time.sleep(5)
##
##    if not trigger_delays == None:
##        if not len(trigger_delays) == img_range:
##            print('error: nbr imgs not equal nbr delays')
##            sys.exit(0)
##    for i in range(img_range):
##        camera.capture(directory + datetime_name + '_' + str(i) + '.jpg')
##        if not trigger_delays == None:
##            sleep(0.5 + trigger_delays[i])
##        else:
##            sleep(0.5)
##
##
##    '''capture a video'''
##    camera.resolution = (1920,1080)
##    camera.framerate = 30   #30 highest possible but than lower resolution
##
##    if trigger_time_vid > time.time():
##        while time.time() < trigger_time_vid:
##            continue
##    
##    camera.start_recording(directory + datetime_name + '.h264')
##    sleep(5)
##    camera.stop_recording()
##    
##    camera.stop_preview()
##
##  
##    '''shut down pi'''
##    #os.system('shutdown now -h')
